#include "stdafx.h"
#include "GMatrix.h"
#include <math.h>


//=======================================================
//                      Definition of GMatrix
//=======================================================


//inline Functions---------------------------------------
inline void GMatrix::allocGMatrix()
{
	_dataMatrix.clear();
	_dataMatrix = vector<vector<double>>(_nbLines, vector<double>(_nbColumns));
	for (  int i = 0; i < _nbLines; ++i)
		for (  int j = 0; j < _nbColumns; j++)
			_dataMatrix[i][j] = 0;
}


inline void GMatrix::getMatrix(const GMatrix& mat)
{
	_dataMatrix.clear();
	_dataMatrix = vector<vector<double>>(_nbLines, vector<double>(_nbColumns));
	for (  int i = 0; i < _nbLines; ++i)
		for (  int j = 0; j < _nbColumns; j++)
			_dataMatrix[i][j] =mat._dataMatrix[i][j];
}

inline void GMatrix::desallocGMatrix()
{
	_dataMatrix.clear();
	//_dataMatrix = 0;
}




inline void GMatrix::setElement ( const int& lineIndex, const int& columnIndex, const double& value){
	_dataMatrix[(lineIndex-1)][(columnIndex-1)] = value;
}

//Constructors and destructors---------------------------
GMatrix::GMatrix()
{
	_nbLines = 0;
	_nbColumns = 0;
	_dataMatrix.clear();
}

GMatrix::GMatrix(  int nbLines,   int nbColumns)
{
	_dataMatrix.clear();
	_nbLines = nbLines;
	_nbColumns = nbColumns;
	allocGMatrix();
}

GMatrix::GMatrix(const GMatrix &mat)
{
	_dataMatrix.clear();
	_nbLines = mat._nbLines;
	_nbColumns = mat._nbColumns;
	this->getMatrix(mat);
}

GMatrix::~GMatrix()
{
	desallocGMatrix();
}

//other methods----------------------------------------

int GMatrix::getNbLines() const
{
	return _nbLines;
}

int GMatrix::getNbColumns() const
{
	return _nbColumns;
}


void GMatrix::initWithValue(double v)
{
	for (int i=0; i<_nbLines; ++i)
	{
		for (int j=0; j<_nbColumns; j++)
		{
			_dataMatrix[i][j]=v;
		}
	}
}



GVector GMatrix::getLine(  int lineIndex) const 
{

    if (lineIndex>_nbLines)
		 throw (GException("GMatrix","GVector GMatrix::getLine(  int lineIndex)","this Line dosen t exist"));

	GVector res(_nbColumns);
	for (  int i = 1; i<=_nbColumns; i++)
		res(i) = this->getElement(lineIndex,i);
	return res;
}

void GMatrix::setLine(  int lineIndex, GVector line) 
{	
	if (lineIndex>_nbLines)
		 throw (GException("GMatrix","void GMatrix::setLine(  int lineIndex, GVector line)","this lineIndex dosen t exist"));
	for(   int i=1;i<=_nbColumns; ++i)
		this->getElement(lineIndex,i) = line(i);
}

double GMatrix::getNormOfLine(  int lineIndex)
{
	if (lineIndex>_nbLines)
		 throw (GException("GMatrix","double GMatrix::getNormOfLine(  int lineIndex)","this Line dosen t exist"));
	double res=0, v;
	for(  int i=1; i< _nbColumns; i++)
	{
		v = this->getElement(lineIndex,i);
		res += v*v;
	}
	return sqrt(res);
}

GVector GMatrix::getColumn(  int columnIndex) const
{
	
    if (columnIndex>_nbColumns)
		throw (GException("GMatrix","GVector GMatrix::getColumn(  int columnIndex)","this Column dosen t exist"));
	GVector res(_nbLines);
	for (  int i = 1; i<=_nbLines; i++)
		res(i) = this->getElement(i, columnIndex);	
	return res;
}

void GMatrix::setColumn(  int columnIndex, GVector column) 
{   
	if (columnIndex>_nbColumns)
		 throw (GException("GMatrix","void GMatrix::setColumn(  int columnIndex, GVector column)","this columnIndex dosen t exist"));
	for(   int i=1;i<=_nbLines; ++i)
		this->getElement(i, columnIndex) = column(i);
}

double GMatrix::getNormOfColumn(  int columnIndex)
{   
	if (columnIndex>_nbColumns)
		throw (GException("GMatrix","double GMatrix::getNormOfColumn(  int columnIndex)","this Column dosen t exist"));
	double res=0, v;
	for(  int i=1; i< _nbLines; i++)
	{
		v = this->getElement(i,columnIndex);
		res += v*v;
	}
	return sqrt(res);
}

int GMatrix::set4x4values(double A11, double A12, double A13, double A14,
						  double A21, double A22, double A23, double A24,
						  double A31, double A32, double A33, double A34,
						  double A41, double A42, double A43, double A44)
{
	if ((_nbLines == 4) && (_nbColumns==4))
	{
		setElement(1,1,A11);	setElement(1,2,A12);	setElement(1,3,A13);	setElement(1,4,A14);
		setElement(2,1,A21);	setElement(2,2,A22);	setElement(2,3,A23);	setElement(2,4,A24);
		setElement(3,1,A31);	setElement(3,2,A32);	setElement(3,3,A33);	setElement(3,4,A34);
		setElement(4,1,A41);	setElement(4,2,A42);	setElement(4,3,A43);	setElement(4,4,A44);
		return 0;
	}
	else return -1;
}


//operators--------------------------------------------

GMatrix& GMatrix::operator =(const GMatrix &mat)
{
	//_dataMatrix = 0;
	_nbLines = mat._nbLines;
	_nbColumns = mat._nbColumns;
	this->allocGMatrix();
	this->getMatrix(mat);
	return *this;
}

const double& GMatrix::operator ()(  int lineIndex,   int columnIndex) const
{
   if ((lineIndex>_nbLines)||(columnIndex>_nbColumns))
   throw (GException("GMatrix","double GMatrix::const double& GMatrix::operator ()(  int lineIndex,   int columnIndex) ","this element dosen t exist"));
   return _dataMatrix[(lineIndex-1)][(columnIndex-1)];
}

double& GMatrix::operator ()(  int lineIndex,   int columnIndex) 
{
   if ((lineIndex>_nbLines)||(columnIndex>_nbColumns))
   throw (GException("GMatrix","double& GMatrix::operator ()(  int lineIndex,   int columnIndex) ","this element dosen t exist"));
   return _dataMatrix[(lineIndex-1)][(columnIndex-1)];
}

GMatrix& GMatrix::operator +=(const GMatrix &mat)
{
   if ((_nbLines!=mat._nbLines)||(_nbColumns!=mat._nbColumns))
   throw (GException("GMatrix","GMatrix& GMatrix::operator +=(const GMatrix &mat)","Matrices with incompatible sizes"));
	for (int i=1; i<=_nbLines; i++)
	{
		for (int j=1; j<= _nbColumns; j++)
		{
			this->getElement(i,j) += mat.getElement(i,j);
		}
	}
	return *this;
}


GMatrix& GMatrix::operator -=(const GMatrix &mat)
{
   if ((_nbLines!=mat._nbLines)||(_nbColumns!=mat._nbColumns))
   throw (GException("GMatrix","GMatrix& GMatrix::operator -=(const GMatrix &mat)","Matrices with incompatible sizes"));	
	for (int i=1; i<=_nbLines; i++)
	{
		for (int j=1; j<= _nbColumns; j++)
		{
			this->getElement(i,j) -= mat.getElement(i,j);
		}
	}
	return *this;
}

GMatrix& GMatrix::operator *=(const GMatrix &mat)
{
	
	if (_nbColumns!=mat._nbLines)
    throw (GException("GMatrix","GMatrix& GMatrix::operator *=(const GMatrix &mat)","Matrices with incompatible sizes"));
	int tmpColumns = mat._nbColumns;
	GMatrix tmp(_nbLines, tmpColumns);
	for (int i=1; i<= _nbLines; i++)
	{
		for(int j=1; j<=tmpColumns; j++)
		{
			for(int k=1; k<=_nbColumns; k++)
			{
				tmp.getElement(i,j) += this->getElement(i,k)*mat.getElement(k,j);
			}
		}
	}
	(*this) = tmp;
	return *this;
}



GMatrix& GMatrix::operator *=(const double &v)
{
	for (int i=0; i<_nbLines; ++i)
	{
		for(int j=0; j<_nbColumns; j++)
		{
			_dataMatrix [i][j] *= v;
		}
	}
	return *this;
}

GMatrix GMatrix::operator +()
{
	return *this;
}

GMatrix GMatrix::operator -()
{
	GMatrix res; res = GMatrix(_nbLines,_nbColumns);
	for (int i=1; i <= _nbLines; i++)
	{
		for (int j=1; j <= _nbColumns; j++)
		{
			res.getElement(i,j) = - this->getElement(i,j);
		}
	}
	return res;
}

GMatrix operator + (const GMatrix& mat1, const GMatrix& mat2)
{
	if ((mat1._nbLines!=mat2._nbLines)||(mat1._nbColumns!=mat2._nbColumns))
    throw (GException("GMatrix","GMatrix operator + (const GMatrix& mat1, const GMatrix& mat2)","Matrices with incompatible sizes"));
	GMatrix res;res = mat1;res += mat2;
	return res;
}

GMatrix operator - (const GMatrix& mat1, const GMatrix& mat2)
{
	if ((mat1._nbLines!=mat2._nbLines)||(mat1._nbColumns!=mat2._nbColumns))
    throw (GException("GMatrix","GMatrix operator - (const GMatrix& mat1, const GMatrix& mat2)","Matrices with incompatible sizes"));
	GMatrix res;res = mat1;res -= mat2;
	return res;
}

GMatrix operator * (const GMatrix& mat1, const GMatrix& mat2)
{
	if (mat1._nbColumns!=mat2._nbLines)
    throw (GException("GMatrix","GMatrix operator * (const GMatrix& mat1, const GMatrix& mat2)","Matrices with incompatible sizes"));
	GMatrix res;res = mat1;res *= mat2;
	return res;
}

GMatrix operator * (const double& v, const GMatrix& mat)
{
	GMatrix res;res = mat;res *= v;return res;
}

GMatrix operator * (const GMatrix& mat, const double& v)
{
	return v*mat;
}


GMatrix operator / (const GMatrix& mat, const double& v)
{
	return (mat*(1.0 / v));
}

GMatrix operator * (const GVector& vect, const GMatrix& mat)
{
	
	
	if (vect.size()!=mat._nbColumns)
    throw (GException("GMatrix","GMatrix operator * (const GVector& vect, const GMatrix& mat)","Vector and Matrix with incompatible sizes"));
	int nbLines = mat._nbLines, nbColumns = mat._nbColumns;
	GMatrix res(nbColumns,nbLines);
	for(int i=1; i<=nbLines; i++)
	{
		for(int j=1; j <= nbColumns; j++)
		{
			res(i,j)=0.0;
			for (int k=1; k<=nbLines; k++)
			{
				res(i,j) += mat(k,j)*vect(i);
			}
		}
	}
	return res;
}

GVector operator * (const GMatrix& mat, const GVector& vect)
{
	
	if (vect.size()!=mat._nbColumns)
    throw (GException("GMatrix","GVector operator * (const GMatrix& mat, const GVector& vect)","Matrix and Vector with incompatible sizes"));
	int nbLines= mat._nbLines;
	GVector res(nbLines);
	for(int i=1; i<=nbLines; i++)
	{
		res(i) = 0.0;
		for(int j=1; j<=mat._nbColumns; j++)
		{
			res(i) += vect(j)*mat(i,j);
		}
	}
	return res;
}

GMatrix operator ~ (const GMatrix& mat)
{

	GMatrix res(mat._nbColumns,mat._nbLines);

	for(int i=1; i<=mat._nbLines; i++)
	{
		for(int j=1; j<=mat._nbColumns; j++)
		{
			res.getElement(j,i) = mat.getElement(i,j);
		}
	}
	return res;
}

ostream& operator << (ostream& out, const GMatrix& mat)
{
	int nbLines = mat.getNbLines(), nbColumns=mat.getNbColumns();
	for(int i=1; i<=nbLines; i++)
	{
		for(int j=1; j<=nbColumns; j++)
			out << mat(i,j)<<'\t';
		out<<endl;
	}
	return out;
}


	



		










